/* transpose x and z dimensions of hankel tranform output   */
/* takes FFT in time (z dimension of hankel ouput)          */
/* flips output to contain pure A and B coefficients        */
/* written by Douglas C. Braun                                                            */
/* Use and modify freely but please inform me at dbraun@cora.nwra.com of questions        */
/* or major improvements and acknowlege the use of this code and its author in any        */
/* relevant publications                                                                  */


#include <stdio.h>
#include <fcntl.h>
#include <math.h>
#include <fftw3.h>
#include "hank_hdr.h"
#include "fitssubs.h"
#include "fitssubs.c"

main( int argc, char *argv[])
{
    long tmp, fdi, fdo, i, j, k, row;
    long naxis1_in, naxis2_in, naxis3_in, naxis4_in;
    long nbr, nbw, nh, numh, imsize_in, imsize_out;
    int rank, istride, ostride;
    int nf2;
    long lastbs, nzp, nbpad;
    long offsetr, offseti;
    char *zpad;
    char *header, *kvalue;
    float *piframe, *poframe;
    float **ppiframe, **ppoframe;
    float ***rstore, ***istore;
    double norm;
    fftw_complex *in, *out;
    fftw_plan fplan;
    const int *nx;
    const int *str;
    int howmany;
    float ftmp, daxis1_in, daxis2_in, daxis3_in, daxis4_in;
    float **array2d(int nrows, int ncols);
    float sign(int m);

    kvalue= (char *) malloc(20);
    header= (char *) malloc(BSIZE);

   
    if (argc != 3) {
        fprintf(stderr, "Usage: %s Hankel_trans AB_coeff_file\n", argv[0]);
        exit(1);
    } 

/* read headers and grab first one */
    numh = readhdr(argv[1]);  
    readhdr1(argv[1], header);

    if (naxis != 4) {
        fprintf(stderr, "%s: naxis = %d -- should be  4\n", argv[0], naxis);
        exit(1);
    }
    naxis1_in = naxis1;
    naxis2_in = naxis2;
    naxis3_in = naxis3;
    daxis1_in = daxis1;
    daxis2_in = daxis2;
    daxis3_in = daxis3;
    naxis1= naxis3_in;
    naxis2= naxis2_in;
    naxis3= naxis1_in;
    daxis1= 1./((float)(naxis3_in)*daxis3_in);
    deltanu=1.e3*daxis1;
    daxis2= daxis2_in;
    daxis3= daxis1_in;
    if (naxis == 4) {
        naxis4_in = naxis4;
        naxis4= naxis4_in;
        daxis4_in = daxis4;
        daxis4= daxis4_in;
    }
    nf2=naxis1/2;

/* allocate 3-D storage array */ 
    rstore = (float ***) malloc(naxis3*sizeof(float **));
    istore = (float ***) malloc(naxis3*sizeof(float **));
    for (k=0; k < naxis3; k++) {
        rstore[k] = array2d(naxis2, naxis1);
        istore[k] = array2d(naxis2, naxis1);
    }

    in = (fftw_complex*) fftw_malloc(naxis1 * naxis2 * sizeof(fftw_complex));
    out = (fftw_complex*) fftw_malloc(naxis1 * naxis2 * sizeof(fftw_complex));

    rank=1;
    istride=1;
    ostride=1;
    str=NULL;
    nx = &naxis1;
    fplan = fftw_plan_many_dft(rank, nx, naxis2, in, str, istride, naxis1, out, str, ostride, naxis1, FFTW_FORWARD, FFTW_ESTIMATE);
    norm=(double)naxis1;

/* write output headers */
    fdi = open (argv[1], O_RDONLY);
    fdo = open (argv[2], O_RDWR | O_CREAT, 0644);

    sprintf(kvalue, "%20d", naxis1);
    update_kwd(header, "NAXIS1", kvalue);
    sprintf(kvalue, "%20d", naxis3);
    update_kwd(header, "NAXIS3", kvalue);
    sprintf(kvalue, "%20.5e", daxis1);
    update_kwd(header, "DAXIS1", kvalue);
    sprintf(kvalue, "%20.5e", daxis3);
    update_kwd(header, "DAXIS3", kvalue);
    sprintf(kvalue, "%20.5e", deltanu);
    update_kwd(header, "DELTANU", kvalue);
    nbw = write(fdo, header, BSIZE);  
    for (nh=1; nh < numh; nh++) {
        nbr = read(fdi, header, BSIZE);
        nbw = write(fdo, header, BSIZE);  
    }


/* allocate size of input z-frame */
    imsize_in=naxis1_in*naxis2_in*sizeof(float);
    piframe = (float *) malloc(naxis1_in*naxis2_in*sizeof(float));
    ppiframe = (float **) malloc(naxis2_in*sizeof(float*));
    for (j=0; j<naxis2_in; j++) ppiframe[j] = piframe + (j*naxis1_in);

/* allocate size of output z-frame */
    imsize_out=naxis1*naxis2*sizeof(float);
    poframe = (float *) malloc(naxis1*naxis2*sizeof(float));
    ppoframe = (float **) malloc(naxis2*sizeof(float*));
    for (j=0; j<naxis2; j++) ppoframe[j] = poframe + (j*naxis1);


/* read input */
    for (k=0; k < naxis3_in; k++) {

        offsetr = BSIZE*numh + (k)*imsize_in;
        lseek(fdi, offsetr, 0);
        if ( (nbr = read(fdi, piframe, imsize_in)) != imsize_in) {
            fprintf(stderr, "%s: Error reading real frame%5d: %d bytes returned\n", argv[0], k, nbw);
            exit(1);
        }
        iswab(piframe,piframe,imsize_in);   
        for (j=0; j < naxis2_in; j++ ) {
            for (i=0; i < naxis1_in; i++ ) {
                rstore[i][j][k] =  ppiframe[j][i];
            }
        }

        offseti = BSIZE*numh + (k+naxis3_in)*imsize_in;
        lseek(fdi, offseti, 0);
        if ( (nbr = read(fdi, piframe, imsize_in)) != imsize_in) {
            fprintf(stderr, "%s: Error reading real frame %5d: %d bytes returned\n", argv[0], k, nbw);
            exit(1);
        }
        iswab(piframe,piframe,imsize_in);   
        for (j=0; j < naxis2_in; j++ ) {
            for (i=0; i < naxis1_in; i++ ) {
                istore[i][j][k] =  ppiframe[j][i];
            }
        }

    }
    close(fdi);

/* take FFT and write output */
    for (k=0; k < naxis3; k++) {
        offsetr = BSIZE*numh + (k)*imsize_out;
        offseti = BSIZE*numh + (k+naxis3)*imsize_out;
        for (j=0; j < naxis2; j++) {
            for (i=0; i < naxis1; i++) {
                in[i+naxis1*j][0]=rstore[k][j][i];
                in[i+naxis1*j][1]=istore[k][j][i];
            }
        }
        fftw_execute(fplan);
        for (row = 0; row < naxis2*naxis1; row++) {
            out[row][0] = out[row][0]/norm;
            out[row][1] = out[row][1]/norm;
        }
        for (j=0; j < naxis2; j++) {
            for (i=0; i < naxis1; i++) {
                ppoframe[j][i] = out[i+naxis1*j][0];
            }
        }
        for (j=1; j <= maxm; j++) {
            for (i=1; i < nf2; i++) {
                ftmp=ppoframe[j][i];
                ppoframe[j][i] = ppoframe[naxis2-j][i];
                ppoframe[naxis2-j][i]=ftmp;
            }
        }
        for (j=1; j <= maxm; j++) {
            for (i=0; i < naxis1; i++) {
                ppoframe[j+maxm][i] *= sign(maxm+1-j);
            }
        }
        iswab(poframe,poframe,imsize_out);   /* FOR INTEL OR DEC ONLY  */
        lseek(fdo, offsetr, 0);
        if ( (nbw = write(fdo, poframe, imsize_out)) != imsize_out) {
            fprintf(stderr, "%s: Error writing real frame %5d: %d bytes returned\n", argv[0], k, nbw);
            exit(1);
        }
        for (j=0; j < naxis2; j++) {
            for (i=0; i < naxis1; i++) {
                ppoframe[j][i] = out[i+naxis1*j][1];
            }
        }
        for (j=1; j <= maxm; j++) {
            for (i=1; i < nf2; i++) {
                ftmp=ppoframe[j][i];
                ppoframe[j][i] = ppoframe[naxis2-j][i];
                ppoframe[naxis2-j][i]=ftmp;
            }
        }
        for (j=0; j < naxis2; j++) {
            for (i=nf2; i < naxis1; i++) {
                ppoframe[j][i] *= -1.;
            }
        }
        for (j=1; j <= maxm; j++) {
            for (i=0; i < naxis1; i++) {
                ppoframe[j+maxm][i] *= sign(maxm+1-j);
            }
        }
        iswab(poframe,poframe,imsize_out);   /* FOR INTEL OR DEC ONLY  */
        lseek(fdo, offseti, 0);
        if ( (nbw = write(fdo, poframe, imsize_out)) != imsize_out) {
            fprintf(stderr, "%s: Error writing imaginary frame %5d: %d bytes returned\n", argv[0], k, nbw);
            exit(1);
        }
    }
    fftw_destroy_plan(fplan);

/* pad output file with zeros to fill 2880 byte record, if necessary */
    lastbs = (sizeof(float)*naxis1*naxis2*naxis3*naxis4)%BSIZE;
    if (lastbs > 0) {
        nbpad = BSIZE-lastbs;
        zpad=(char *)malloc(nbpad);
        offsetr = BSIZE*numh + (naxis3*naxis4*imsize_out);
        for (nzp=0; nzp < nbpad; nzp++) zpad[nzp] = 0;
        lseek(fdo, offsetr, 0);
        if ( (nbw = write (fdo, zpad, nbpad)) != nbpad) {
          fprintf(stderr, "%s: Error writing zero-pad in %s - returned %d bytes\n", argv[0], argv[2], nbw);
        }
        free(zpad);
    }
    close(fdo);
    close(fdi);

    free(ppoframe);
    free(poframe);
    free(ppiframe);
    free(piframe);
    free(istore);
    free(rstore);
    free(header);
    free(kvalue);

}

float **array2d(int nrows, int ncols)
{
    int i;
    float **a;
    a = (float **) malloc((unsigned)(nrows)*sizeof(float *));
    for (i=0; i < nrows; i++) {
        a[i] = (float *) malloc((unsigned)(ncols)*sizeof(float));
    }
    return a;
}
float sign(int m)
{
    int i;
    float s = 1.;
    if (m==0) return(s);
    else {
        for (i=1; i <=abs(m); i++) s *= -1.;
    }
    return(s);
}

