PRO COMPUTE_POWER, a, p1, pow

siz=SIZE(a)
IF(siz[0] NE 3) THEN BEGIN
  MESSAGE, 'Image argument must be 3D.', /CONTINUE
  RETURN
ENDIF
u=siz[1] & v=siz[2] & w=siz[3]

temp=FLTARR(u,w/2)
pow=FFT(a)
FOR i=0,u/2-1 DO BEGIN
  FOR j=0,v/2-1 DO BEGIN
    FOR k=0,w/2-1 DO BEGIN
      ii=ROUND(SQRT((1.*i)^2+(1.*j)^2))
      temp(ii,k)=temp(ii,k)+ABS(pow(i,j,k))^2
    ENDFOR 
  ENDFOR
ENDFOR
p1=temp(0:u/2-1,*)

TRANSFORM,pow,temp
pow=(ABS(temp))^2

RETURN
END
