; scatter plot of two images
pro scatter,im1,im2,title=title,xtitle=xtitle,ytitle=ytitle

!p.multi=[0,1,1]
!p.thick = 2.0
!x.thick = 1.5
!y.thick = 1.5
!x.charsize=1.5
!y.charsize=1.5
if not keyword_set(xtitle) then xtitle='image 1'
if not keyword_set(ytitle) then ytitle='image 2'
if not keyword_set(title) then title=''

x=im1
y=im2
pmin1=min(x)
pmax1=max(x)
pmin2=min(y)
pmax2=max(y)
pmin=min(pmin1,pmin2)
pmax=max(pmax1,pmax2)
xrg=[pmin,pmax]
yrg=[pmin,pmax]
aspct=(yrg[1]-yrg[0])/(xrg[1]-xrg[0])
plot,x,y,psym=3, title=' ',$
  xtitle = xtitle,ytitle=ytitle,$
  xs=1, ys=1,xrange=xrg, yrange=yrg, position=aspect(aspct) 
oplot,xrg,[0,0],line=2
oplot,[0,0],yrg,line=2
oplot,xrg,yrg,lin=0

end
